//----------------------------------------------------------------------------
//
// Copyright (C) Sartorius Stedim Data Analytics AB 2017 -
//
// Use, modification and distribution are subject to the Boost Software
// License, Version 1.0. (See http://www.boost.org/LICENSE_1_0.txt)
//
//----------------------------------------------------------------------------

#include "stdafx.h"
#include "sqmrunner.h"
#include "utf8util.h"

#ifdef __unix__
#include <unistd.h>
#include <stdlib.h>
#endif


#ifdef _WIN32
#include <io.h>
#endif

#ifdef _WIN32
int _tmain(int argc, TCHAR* argv[], TCHAR* /*envp[]*/)
{
   FILE* pInFile = NULL;
   SQ_Project pProject = NULL;
   char* utf8argv1;

   if (argc != 3)
   {
      _ftprintf(stderr, _T("\n%s: Usage:\n\n")
         _T(".\\SQMCSample.exe <USP-file> <Input file>\n\n")
         _T("    USP-file     --- is the output SIMCA project file\n")
         _T("    Input file   --- is a file to import.\n\n"),
         argv[0]);
      return -1;
   }

   /* Open the input file. */
   pInFile = _tfopen(argv[2], _T("r"));
   if (pInFile == NULL)
   {
      _ftprintf(stderr, _T("\n%s: Could not open input file: %s\n")
         _T("Make sure that the file is not missing ")
         _T("and is readable for your user\n\n"), argv[0], argv[2]);
      return -1;
   }

   utf8argv1 = TCHARtoUTF8(argv[1]);
   pProject = SQMRunner_Import(utf8argv1, pInFile, stderr);
   if (pProject)
   {
      if (SQMRunner_Workset(pProject, stderr))
         SQMRunner_Fit(pProject, stderr);

      SQ_CloseProject(&pProject);
   }
   return 0;
}

#else
int main(int argc, char* argv[], char* envp[])
{
   FILE* pInFile = NULL;
   SQ_Project pProject = NULL;

   if (argc != 3)
   {
      fprintf(stderr, "%s: Usage: "
              "USP-file Input file\n"
              "USP-file is a SIMCA project file\n"
              "Input file is a file to import.\n",
              argv[0]);
      return -1;
   }
   
   /* Open the input file. */
   pInFile = fopen(argv[2], "r");
   if (pInFile == NULL)
   {
      fprintf(stderr, "%s: Could not open input file: "
         "%s\n", argv[0], argv[2]);
      return -1;
   }

   pProject = SQMRunner_Import(argv[1], pInFile, stderr);
   if (pProject)
   {
      if (SQMRunner_Workset(pProject, stderr))
         SQMRunner_Fit(pProject, stderr);

      SQ_CloseProject(&pProject);
   }
   return 0;
}
#endif
